% TRACTION uses Fourier Transform Traction Microscopy to compute the
% tractions that a cell exerts on its substrate. The algorithm is described
% in Butler al, AJP-Cell, 2002. A typical experiment involves one or more
% images of the fluorescent beads embeded in the gels, the corresponding 
% one of more phase contrast images of the cell, and a reference image obtained 
% after trypsinizing the cell.
%
% Variables:
%   SETTINGS contains the user-defined information needed by the algoritm
%   FILE contains information about the each of the files opened
%   RESULTS contains the results of the computation.


%%
% Instructions by - Md. Mydul Islam Miku, miku@knights.ucf.edu

% To run this code follow these instructions-
% Make your MATLAB directory as such- C:\code\Trac_MSM_Code 
% Inside Trac_MSM_Code make a folder named "code" (copy all of your codes inside this "code" folder)
% Inside Trac_MSM_Code make a folder named "data" (copy all of your data here)
% Keep model.in file and island.exe file inside the "data" folder


% Edited and modified for windows by Md. Mydul Islam Miku 2017, 2018, 2019
% contact miku@knights.ucf.edu

%This code is specifically modified for windows. For MAC version of code,
%contact Dr. Robert steward Jr., rstewardjr@ucf.edu

%clear all;

close all;
%%
%Set variables
obj = 5;
mag = 1;
Settings.PixelSize = (6.5/mag)/obj; % size of one pixel after magnification in MICRONS (typically physical size of the pixel on the CCD * Magnification)
Settings.Imgfmt='tif'; % image format
Settings.Young = 1.2*1e3; % Young's modulus of the gel. 
Settings.Poisson = 0.5; % Poisson ratio
Settings.Filter.Type = 'LP'; % 'LP' for a low pass filter or 'wiener' for an adaptive wiener filter.


%%
%Open all image files
%File = OpenFiles(Settings);

%% Crop images

ROI(1).i1=150;
ROI(1).i2=1749;
ROI(1).j1=300;
ROI(1).j2=1899; %j is image width in X, i is image height in Y 

%File = cell_cropper(Settings,File,ROI);

%%
%Compute Gel Displacement 


Settings.resolution = 32; % Size of each window of the PIV analysis
Settings.overlap = 0.75; % Overlap between windows for PIV analysis. 0 means no overlap, 1 means full overlap(1 not recommended)  

%File = displacement_finder(Settings,File);

%%
%compute stage drift

Settings.disp_max = 4;% sets color bar limit for displacement 

%File = dedrift(Settings,File);%use for bead defrift

%%
% Compute the traction field

% Results for all files written into Results.dat - rms traction (Pa), netmoment (pj),
% and strain energy (pj)


Settings.Filter.CutFreq = 1; % cutoff frequency in units of the nyquist frequency originally 
Settings.FlipMatrix = 'no';%flip matrix for edge or interior assay only.
Settings.GelHeight = 100;% Gel Height input if using traction_finite
Settings.height = 'finite';%'infinite','finite','constrained' , tells what traction code to use
Settings.DedriftImage = 'yes';%was image dedrifted above?
Settings.TracBoundCond = 'unconstrained';%traction boundary condition constrained or unconstrained

%File = traction_finder(Settings,File,ROI);


%%
% Plot the traction results

Settings.reshapeMatrix = 'yes';%reshape image to reduce traction pixelation in plot_traction.m 
Settings.PlotDisp = 'yes';%plot displacements yes or no
Settings.PlotTracX = 'yes';%plot tractions in x
Settings.PlotTracY = 'yes';%plot tractions in y
Settings.PlotRmsTrac = 'yes';%plot rms tractions
Settings.cropFig = 'no';

%Traction and Stress colorbar limits for plots
Settings.disp_max = 5;
Settings.trac_max = 40;
Settings.tracx_max = 25;
Settings.tracx_min = -5;

%plot_traction(Settings,File,ROI);
%%
% mark the boundary of cell islands manually
% For N number of images, draw boundary N times. 

Settings.DomDrawn = 'no';%was domain for monolayer boundary drawn?
Settings.DomImagej = 'no';%was domain drawn using imagej?
 
%mark_circular_domain(File,Settings)

%%
% IMPORTANT: Before running this, make sure you have properly edited model.in file
% Check if pixel to micron conversion, young's modulus etc.
% If pixel to micron doesn't match what's in settings, results will not
% come.

imagenum = 2; %specify the number of images you have
%Run_StressCode(imagenum);

%%
%Plot Intercellular Stresses
Settings.reshapeMatrix = 'yes';% set to yes to reduce pixelation
Settings.max_shear_max = 400;
Settings.avg_norm_min = 0;
Settings.avg_norm_max = 400;
Settings.domSize = [196 196];%Use nXPts for this 
%Also, you can use by calculating domsize as such-if cropped image size is 1152 x 1152 (must be square) with 32 bit
%then resolution domSize = 1152/32 = 36

Settings.PlotStresses = 'yes';%plot stress distribution
Settings.EvenStresses = 'yes';%even stress matrix to match traction matrix

%tic        
%plot_FEM_results(File,Settings);
%toc
%%




